@extends('gestions.layouts')

@section('content')
    <div class="row justify-content-center mt-3">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="float-start">
                        Expéditions du
                        @if (!empty($date))
                            {{ strftime('%A %e %B %Y', strtotime($date)) }}
                        @endif
                    </div>
                    <div class="float-end">
                        <a href="{{ route('gestions.index') }}" class="btn btn-info btn-sm">&larr; Retour</a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($gestions->isEmpty())
                        <p>Aucune expéditions enregistrée pour ce jour.</p>
                    @else
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">Produit</th>
                                    <th scope="col">Quantité</th>
                                    <th scope="col">Motif</th>
                                    <th scope="col">Client</th> <!-- Colonne vide pour le bouton -->
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($gestions as $gestion)
                                    <tr>
                                        <td>{{ $gestion->produit->getDescriptifFullOrAlter() }}</td>
                                        <td class="text-center">{{ $gestion->quantite * 1 }} {{ $gestion->unite }}</td>
                                        <td>{{ $gestion->motif }}</td>
                                        <td>{{ $gestion->client }}</td>
                                        <td>
                                            <form action="{{ route('gestions.destroy', $gestion->id) }}" method="post" id="deleteForm_{{ $gestion->id }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?')">
                                                    <i class="bi bi-trash"></i> 
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach


                            </tbody>
                        </table>
                    @endif
                </div>
                <form action="{{ route('gestions.store') }}" method="post">
                    @csrf
                    <input type="hidden" name="date" value="{{ $date }}">
                    <!-- Ajoutez d'autres champs du formulaire ici -->

                    <div class="mb-3 row">
                        <label for="famille" class="col-md-4 col-form-label text-md-end text-start">La Famille</label>
                        <div class="col-md-6">
                            <select class="form-control @error('famille') is-invalid @enderror select2" name="famille"
                                id="famille">
                                @foreach ($familles as $famille)
                                    <option value="{{ $famille }}" @if (old('famille') == $famille) selected @endif>
                                        {{ $famille }}
                                    </option>
                                @endforeach
                            </select>
                            @error('famille')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                   
                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control @error('produit_id') is-invalid @enderror select2" name="produit_id" id="produit_id" data-familles="{{ json_encode($familles) }}" data-produits="{{ json_encode($produits) }}">
                                @foreach ($produits as $produit)
                                    <option data-famille="{{ $produit->famille }}" value="{{ $produit->id }}" @if (old('produit_id') == $produit->id) selected @endif>
                                        {{ $produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter() }}
                                    </option>
                                @endforeach
                            </select>
                            @error('produit_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité produite</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control @error('quantite') is-invalid @enderror" id="quantite" name="quantite" value="{{ old('quantite') }}">
                            @error('quantite')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>


                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror select2" name="unite" id="unite">
                                @foreach (['Palette', 'm3', 'Stère', 'Pile', 'ml', 'Pièce', 'Kilo', 'Rouleau', 'm2'] as $option)
                                    <option value="{{ $option }}" @if (old('unite') == $option) selected @endif>{{ $option }}</option>
                                @endforeach
                            </select>
                            @error('unite')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                            </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="motif" class="col-md-4 col-form-label text-md-end text-start">Motif</label>
                        <div class="col-md-6">
                            <select class="form-control @error('motif') is-invalid @enderror select2" name="motif" id="motif">
                                @foreach (['Vente Client', 'Transfert Castagné', 'Entrer Four', 'Autres'] as $option)
                                    <option value="{{ $option }}" @if (old('motif') == $option) selected @endif>{{ $option }}</option>
                                @endforeach
                            </select>
                            @error('motif')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="detail_client" class="col-md-4 col-form-label text-md-end text-start">Détail client</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control @error('detail_client') is-invalid @enderror" id="detail_client" name="detail_client" value="{{ old('detail_client') }}">
                            @error('detail_client')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
           


            

                    <div class="mb-3 row">
                    
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-info" value="Ajouter le Produit">
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
    function confirmDelete(gestionId) {
        console.log('Confirm delete function called with ID:', gestionId);
        var isConfirmed = confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?');
        console.log('Confirmation status:', isConfirmed);

        if (isConfirmed) {
            // Supprimer le produit en stock
            document.getElementById('deleteForm_' + gestionId).submit();
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.btn-confirm-delete').forEach(function (button) {
            button.addEventListener('click', function () {
                var gestionId = this.getAttribute('data-gestion-id');
                confirmDelete(gestionId);
            });
        });
    });
</script>

@endsection
