<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Stock extends Model {
    use HasFactory, Sortable;
    
    protected $fillable = ['date_mouvement', 'produit_id', 'unite','quantite', 'motif', 'colis_id' ,'nombre_colis'];

    public function produit(): BelongsTo {
        return $this->belongsTo(Produit::class);
    }
    public function colis(): BelongsTo {
        return $this->belongsTo(Colis::class);
    }
    protected $casts = [
        'date_mouvement' => 'datetime'
    ];
}
