<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class Commande extends Model {
    use HasFactory, Sortable;

    protected $fillable = ['date_commande', 'client_id', 'produit_id', 'quantite', 'unite', 'date_annonce', 'statut', 'observations'];

    public function produit(): BelongsTo {
        return $this->belongsTo(Produit::class);
    }
    public function client(): BelongsTo {
        return $this->belongsTo(Client::class);
    }
}
