<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreStockRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array {
        return [
            'date_mouvement' => 'date', 
            'produit_id' => 'exists:App\Models\Produit,id', 
            'unite' => 'string',
            'quantite' => 'decimal:0,3',
            'motif' => 'nullable|string', 
            'colis_id' => 'nullable|exists:App\Models\Colis,id',
            'nombre_colis' => 'nullable|integer'
        ];
    }
}
