<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreInventaireRequest;
use App\Http\Requests\UpdateInventaireRequest;
use App\Models\Inventaire;
use App\Models\Produit;
use Illuminate\Support\Facades\DB;

class InventaireController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index() {
        //Question::with('answers')->get();
        return view('inventaires.index', ['inventaires' => Inventaire::with('produit')->get() ]);
    }

    public function chiffre() {
        $qA = Inventaire::select(DB::raw('inventaires.*, tarifs.prix_revient'))
        ->leftJoin('tarifs', 'inventaires.produit_id', "=", "tarifs.produit_id")->get() ;
        return view('inventaires.chiffre', ['inventaires' => $qA]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create() {
	    return view('inventaires.create', [
            'produits' => Produit::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreInventaireRequest $request) {
        Inventaire::create($request->all());
	    return redirect()->route('inventaires.index')
                ->withSuccess("Stock d'inventaire mis à jours avec succes.");
    }

    /**
     * Display the specified resource.
     */
    public function show(Inventaire $inventaire)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Inventaire $inventaire)
    {
	    return view('inventaires.edit', [
            'inventaire' => $inventaire,
            'produits' => Produit::all()
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateInventaireRequest $request, Inventaire $inventaire) {
        $inventaire->update( $request->all() );
        return redirect()->route('inventaires.index')
                ->withSuccess("L'Inventaire' a été mis à jours correctement.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Inventaire $inventaire) {
	    $inventaire->delete();
        return redirect()->route('inventaires.index')
                ->withSuccess("L'inventaire a été supprimé pour ce Produit.");
    }
}
