<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\StoreGestionRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\UpdateGestionRequest;
use App\Models\Gestion;
use App\Models\Produit;
use App\Models\Stock;


class GestionController extends Controller
{
    /**
     * Display a listing of the resource.
     * 2024-01-22 - Modif YMF pour affichier seulement les produits affecté à briolance ou null.
     */
    public function index(Request $request)
    {
        // Récupérer la date spécifiée à partir de la requête
        $date_mouvement = $request->input('date_mouvement', date('Y-m-d'));
    
        // Récupérer le stock correspondant à la date spécifiée
        $stock = Stock::with('produit')
            //->where('produits.site', "!=", "Loubejac")
            ->whereHas('produit', function($query) {
                $query->where('site', '!=', 'Loubejac');
	    })
	    ->orderBy("date_mouvement", 'desc')
            ->get();
    
        // Autres données dont vous pourriez avoir besoin
        $produits = Produit::all();
    
        return view('gestions.index', compact('stock', 'produits', 'date_mouvement'));
    }
    
    
    

    /**
     * Show the form for creating a new resource.
     * 2024-01-22 - Modif YMF pour afficher seulement les produits affecté à briolance ou null.
     */
    public function create($date = null)
    {
	// Utilser la date fournie dans l'URL ou la date actuelle si aucune date n'est fournie
	// YMF Un truc cloche avec cette partie a creuser !!!
        $date = $date ?? now()->toDateString();

	// YMF Cette requete et cette variable sont elles necessaires. ???
        $stocksDuJour = Stock::with('produit')
            ->whereDate('date_mouvement', $date)
            ->get();

	// Dans cet ecran on ne pourra ajouter que des produits de Briolance
        $produits = Produit::where('site','!=', 'Loubejac')->get();

	// On affichera le stock du jour que des produits de briolance
        $gestions = Stock::with('produit')
             ->whereHas('produit', function($query) {
                $query->where('site', '!=', 'Loubejac');
            })->orderBy("date_mouvement", 'desc')
            ->whereDate('date_mouvement', $date)
            ->get();
    

     // Utilisation d'une requête SQL brute pour obtenir les familles distinctes
        $familles = DB::table('produits')->select('famille')->distinct()->pluck('famille', 'famille');

        return view('gestions.create', compact('gestions', 'stocksDuJour', 'produits', 'date', 'familles'));

    }
    
    
    /**
     * Store a newly created resource in storage.
     */

     public function store(Request $request)
     {
         // Valider les données du formulaire
         $request->validate([
             'produit_id' => 'required',
             'quantite' => 'required|numeric',
             'unite' => 'required',
             // Ajoutez ici d'autres règles de validation au besoin
         ]);
 
         // Créer un nouvel enregistrement de stock avec les données du formulaire
         $stock = new Stock();
         $stock->produit_id = $request->produit_id;
         $stock->quantite = $request->quantite;
         $stock->unite = $request->unite;
         $stock->motif = $request->motif;
         // Ajoutez ici d'autres champs si nécessaire
         $stock->save();
 
         // Rediriger avec un message de succès
         return redirect()->route('gestions.index')->withSuccess('Le stock a été ajouté avec succès.');
        }
     

    /**
     * Display the specified resource.
     */
    public function show(Gestion $gestion)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($date = null)
    {
	// Utilser la date fournie dans l'URL ou la date actuelle si aucune date n'est fournie
	// YMF Un truc cloche avec cette partie a creuser !!!
    $date = $date ?? now()->toDateString();

	// YMF Cette requete et cette variable sont elles necessaires. ???
        $stocksDuJour = Stock::with('produit')
            ->whereDate('date_mouvement', $date)
            ->get();

	// Dans cet ecran on ne pourra ajouter que des produits de Briolance
        $produits = Produit::where('site','!=', 'Loubejac')->get();

	// On affichera le stock du jour que des produits de briolance
        $gestions = Stock::with('produit')
             ->whereHas('produit', function($query) {
                $query->where('site', '!=', 'Loubejac');
            })->orderBy("date_mouvement", 'desc')
            ->whereDate('date_mouvement', $date)
            ->get();
    

     // Utilisation d'une requête SQL brute pour obtenir les familles distinctes
        $familles = DB::table('produits')->select('famille')->distinct()->pluck('famille', 'famille');

        return view('gestions.edit', compact('gestions', 'stocksDuJour', 'produits', 'date', 'familles'));

    }


    



    /**
     * Remove the specified resource from storage.
     */
   

    public function destroy(Stock $stock)
    {
    // Utiliser la date du stock pour la suppression
    $date = $stock->date_mouvement;


    $stocksDuJour = Stock::with('produit')
        ->whereDate('date_mouvement', $date)
        ->get();

    $produits = Produit::all();

    $gestions = Stock::with('produit')
        ->whereDate('date_mouvement', $date)
        ->orderBy('date_mouvement', 'desc')
        ->get();

    // Définir la variable de session pour indiquer la source
    Session::put('source', 'gestion.destroy');

    // Effectuer la suppression du stock
    $stock->delete();

    return redirect()->route('gestions.index', ['date' => $date])
        ->withSuccess('Le Produit a été correctement supprimé.');
}


    
}
